
//-f

#version 3.7;

global_settings {assumed_gamma 2.2}

#declare NORTH_SOUTH = 0;
#declare EAST_WEST   = 1;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                 * */
/* *   SET THESE VARIABLES: (All distances should be in feet)                                        * */
/* *                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local Orientation = EAST_WEST; //NORTH_SOUTH or EAST_WEST

#local LocalElevation = 2894; //Flathead Lake = 2,894'

#local H0 = 1; //Height of the visible object
#local H1 = 4; //Height of the traveling observer's viewpoint ("Eye level")
#local H2 = 2; //Height of the desired Earth bump between the visible object and the observer

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                 * */
/* *   INITIALIZE SCENE                                                                              * */
/* *                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

camera {
   orthographic
   location <-6, 2, -40>
   look_at <-6, 2, 0>
   scale <image_width / image_height, 4/3, 1>
} //camera

#include "colors.inc"

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local EarthColor_Bright = texture {pigment {color <0, .6, 1>} finish {emission .9}}
#local EarthColor_Dim    = texture {pigment {color <0, .6, 1> * .5} finish {emission .9}}
#local EarthColor_Inner  = texture {pigment {color <0, .6, 1> * .3} finish {emission .9}}
#local LineColor_Radius  = texture {pigment {color Orange} finish {emission .9}}
#local LineColor_Center  = texture {pigment {color Yellow} finish {emission .9}}
#local LineColor_Tangent = texture {pigment {color White} finish {emission .9}}
#local TextColor0        = texture {pigment {color <.6, 1, 0> * .8} finish {emission .9}}
#local TextColor1        = texture {pigment {color <.6, 1, 0>} finish {emission .9}}
#local LabelColor        = texture {pigment {color <1, 0, .6>} finish {emission .9}}
#local NoteColor         = texture {pigment {color White * .5} finish {emission .9}}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                 * */
/* *   MACROS                                                                                        * */
/* *                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#macro FormatNumberString (NumberString_)

   #local NumberString = NumberString_;

   #if (val (NumberString) < 0)
      #local Sign = "-";
   #else
      #local Sign = "";
   #end //#if

   #local AbsoluteValue = abs (val (NumberString));

   #local Integer = int (AbsoluteValue);
   #local IntegerString = "";

   #if (Integer > 0)
      #local TempIntegerString = str (Integer, 0, 0);
      #local L = strlen (TempIntegerString);
      #local Count = 0;
      #for (I, L, 1, -1)
         #local Count = mod (Count + 1, 3);
         #if (Count = 0 & I > 1)
            #local CommaString = ",";
         #else
            #local CommaString = "";
         #end //#if
         #local IntegerString = concat (CommaString, substr (TempIntegerString, I, 1), IntegerString);
      #end //#for
   #else
      #local IntegerString = "0";
   #end //#if

   #local L = strlen (NumberString);
   #local DecimalFound = no;
   #for (I, 1, L)
      #if (substr (NumberString, I, 1) = ".")
         #local DecimalFound = yes;
         #break
      #end //#if
   #end //#for
   #if (DecimalFound)
      #local DecimalString = substr (NumberString, I, L - I + 1);
   #else
      #local DecimalString = "";
   #end //#if

   concat (Sign, IntegerString, DecimalString)

#end //#macro FormatNumberString

#macro Print (String_, X0_, Y0_, TextColor_, S_)

   #local String    = String_;
   #local X0        = X0_;
   #local Y0        = Y0_;
   #local TextColor = TextColor_;
   #local S         = S_;

   #local Font = "Arial.ttf"

   object {
      text {ttf Font String 1, 0}
      texture {TextColor}
      scale <S, S, 1>
      translate <X0, Y0, 0>
   } //object

#end //#macro Print

#macro MakeLine (P0_, P1_, Width_, LineColor_, ZDepth_)

   #local P0        = P0_;
   #local P1        = P1_;
   #local Width     = Width_;
   #local LineColor = LineColor_;
   #local ZDepth    = ZDepth_;

   #local P0 = <P0.x, P0.y, 0>;
   #local P1 = <P1.x, P1.y, 0>;

   #local Line = object {
      union {
         sphere {P0, Width / 2}
         sphere {P1, Width / 2}
         cylinder {P0, P1, Width / 2}
      } //union
      texture {LineColor}
      translate ZDepth * z
   } //object

   object {Line}

#end //#macro MakeLine

#macro ComputeIntersectionPoint (P0_, A0_, P1_, A1_)

   #local P0 = P0_;
   #local A0 = A0_;
   #local P1 = P1_;
   #local A1 = A1_;

   #local A0 = mod (A0, 360);
   #local A1 = mod (A1, 360);

   #if (P0.x = P1.x & P0.y = P1.y)
      #if (A0 = A1)
         #error "No unique intersection point exists."
      #else
         P0
         #break
      #end //#if
   #end //#if

   #if (A1 - A0 = 0 | A1 - A0 = 180)
      #error "No unique intersection point exists."
   #end

   #if (P1.x < P0.x)
      #local TPoint = P1;
      #local TAngle = A1;
      #local P1 = P0;
      #local A1 = A0;
      #local P0 = TPoint;
      #local A0 = TAngle;
   #end //#if

   #local XOffset = P0.x;
   #local YOffset = P0.y;

   #local P0 = <0, 0, 0>;
   #local P1 = P1 - <XOffset, YOffset, 0>;

   #if (P1.x = 0)
      #if (P1.y > 0)
         #local Theta = 90;
      #else
         #local Theta = 270;
      #end //#if
   #else
      #local Theta = degrees (atan (P1.y / P1.x));
   #end //#if

   #local R2 = sqrt (P1.x * P1.x + P1.y * P1.y);

   #local A0 = A0 - Theta;
   #local A1 = A1 - Theta;

   #local P1 = <R2, 0, 0>;

   #local A1 = 180 - A1;

   #local A3 = 180 - A0 - A1;

   #local R1 = R2 * sin (radians (A1)) / sin (radians (A3));

   #local A0 = A0 + Theta;

   <R1 * cos (radians (A0)) + XOffset, R1 * sin (radians (A0)) + YOffset, 0>

#end //#macro ComputeIntersectionPoint

#macro ComputeArcLength (Orientation_, LocalElevation_, H0_, H1_, H2_, AtmosphericRefractionFactor_)

   #local Orientation                 = Orientation_;
   #local LocalElevation              = LocalElevation_;
   #local H0                          = H0_;
   #local H1                          = H1_;
   #local H2                          = H2_;
   #local AtmosphericRefractionFactor = AtmosphericRefractionFactor_;

   #if (Orientation = NORTH_SOUTH)
      #local EarthCircumference = 24859.734;
   #else
      #local EarthCircumference = 24901.461;
   #end //#if

   #local EarthCircumference = EarthCircumference * AtmosphericRefractionFactor * 5280;
   
   #local EarthRadius = EarthCircumference / (2 * pi) + LocalElevation * AtmosphericRefractionFactor;

   #local R0 = EarthRadius + H0;
   #local R1 = EarthRadius + H1;

   #local A0 = degrees (acos ((EarthRadius - H2) / R0));
   #local A1 = degrees (acos ((EarthRadius - H2) / R1));
   #local A = A0 + A1;

   A / 360 * EarthCircumference / 5280;

#end //#macro ComputeArcLength

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                 * */
/* *   COMPUTE VISIBILITY DISTANCES                                                                  * */
/* *                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local ArcLength_NoAR  = ComputeArcLength (Orientation, LocalElevation, H0, H1, H2, 1)
#local ArcLength_AvgAR = ComputeArcLength (Orientation, LocalElevation, H0, H1, H2, 4/3)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                 * */
/* *   DRAW AN ILLUSTRATION                                                                          * */
/* *                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

//Re-scale the Earth for illustration purposes:

#local EarthCircumference = 40 * pi;
#local EarthRadius = EarthCircumference / (2 * pi);
#local R0 = EarthRadius + H0;
#local R1 = EarthRadius + H1;
#local A0 = degrees (acos ((EarthRadius - H2) / R0));
#local A1 = degrees (acos ((EarthRadius - H2) / R1));
#local A = A0 + A1;

#local LineWidth = .2;

#local Earth = object {
   disc {<0, 0, 0>, z, EarthRadius + LineWidth / 2, EarthRadius - LineWidth / 2}
} //object

#local Earth0 = object {
   intersection {
      disc {<0, 0, 0>, z, EarthRadius + LineWidth / 2, EarthRadius - LineWidth / 2}
      plane {y, 0 inverse}
      plane {y, 0 rotate A * z}
   } //intersection
   texture {EarthColor_Bright}
} //object

#local Earth1A = object {
   union {
      intersection {
         disc {<0, 0, 0>, z, EarthRadius + LineWidth / 2, EarthRadius - LineWidth / 2}
         plane {y, 0}
      } //intersection
      disc {<-EarthRadius, 0, 0>, z, LineWidth / 2}
   } //union
   texture {EarthColor_Dim}
} //object

#local Earth1B = object {
   intersection {
      disc {<0, 0, 0>, z, EarthRadius + LineWidth / 2, EarthRadius - LineWidth / 2}
      plane {y, 0 inverse}
      plane {y, 0 inverse rotate A * z}
   } //intersection
   texture {EarthColor_Dim}
} //object

#local Earth2 = object {
   disc {<0, 0, 0>, z, EarthRadius - LineWidth / 2}
   texture {EarthColor_Inner}
} //object

object {Earth0}
object {Earth1A}
object {Earth1B}
object {Earth2}

#local P0 = <R0, 0>;
#local P1 = <cos (radians (A)) * R1, sin (radians (A)) * R1>;

#local P2A = ComputeIntersectionPoint (<0, 0>, A0, P0, A0 + 90);
#local P2B = <cos (radians (A0)) * EarthRadius, sin (radians (A0)) * EarthRadius>;

MakeLine (<cos (radians (A)) * EarthRadius, sin (radians (A)) * EarthRadius>, P1, LineWidth, LineColor_Radius, 0)

MakeLine (<EarthRadius, 0>, P0, LineWidth, LineColor_Radius, 0)

MakeLine (P0, P1, LineWidth, LineColor_Tangent, -1)

#if (H2 > 0)
   MakeLine (P2A, P2B, LineWidth, LineColor_Center, 0)
#end //#if

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                 * */
/* *   GENERATE REPORT                                                                               * */
/* *                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local S = 1.5;

#local TextX0 = -55;
#local TextX1 = -30.5;
#local TextY = 25;

Print ("Travel direction:", TextX0, TextY, TextColor0, S)
#if (Orientation = NORTH_SOUTH)
   #local String = "north/south";
#else
   #local String = "east/west";
#end //#if
Print (String, TextX1, TextY, TextColor1, S)
#local TextY = TextY - S * 1.5;

Print ("Local elevation:", TextX0, TextY, TextColor0, S)
Print (concat (FormatNumberString (str (LocalElevation, 0, 0)), "'"), TextX1, TextY, TextColor1, S)
#local TextY = TextY - S * 1.5;

Print ("Height of the visible object:", TextX0, TextY, TextColor0, S)
Print (concat (str (H0, 0, 1), "'"), TextX1, TextY, TextColor1, S)
#local TextY = TextY - S * 1.5;

Print ("Height of the observer's viewpoint:", TextX0, TextY, TextColor0, S)
Print (concat (str (H1, 0, 1), "'"), TextX1, TextY, TextColor1, S)
#local TextY = TextY - S * 1.5;

Print ("Height of the desired Earth bump:", TextX0, TextY, TextColor0, S)
Print (concat (str (H2, 0, 1), "'"), TextX1, TextY, TextColor1, S)
#local TextY = TextY - S * 1.5;

Print ("Distance the observer must travel:", TextX0, TextY, TextColor0, S)
#local TextY = TextY - S * 1.5;

Print ("     No atmospheric refraction:", TextX0, TextY, TextColor0, S)
Print (concat (str (ArcLength_NoAR, 0, 2), " miles"), TextX1, TextY, TextColor1, S)
#local TextY = TextY - S * 1.5;

Print ("     Average atmospheric refraction:", TextX0, TextY, TextColor0, S)
Print ("~", TextX1, TextY - .125, TextColor1, S)
Print ("~", TextX1, TextY + .125, TextColor1, S)
Print (concat (str (ArcLength_AvgAR, 0, 2), " miles"), TextX1 + .95, TextY, TextColor1, S)

Print ("Visible object", P0.x + 1, P0.y, LabelColor, S)
Print ("Earth bump", P2B.x + 1, P2B.y, LabelColor, S)
Print ("Observer", P1.x + 1, P1.y, LabelColor, S)

Print ("*Earth not drawn to scale", 16, -EarthRadius - LineWidth / 2, NoteColor, S)
